/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.loaders.lw3d;

import com.sun.j3d.internal.J3dUtilsI18N;
import javax.media.j3d.Alpha;
import javax.media.j3d.Interpolator;

abstract class FloatValueInterpolator
extends Interpolator {
    private float[] knots;
    private int knotsLength;
    protected int currentKnotIndex;
    protected float currentInterpolationRatio;
    protected float[] values;
    protected float currentValue;

    FloatValueInterpolator(Alpha alpha, float[] fArray, float[] fArray2) {
        super(alpha);
        int n2;
        this.knotsLength = fArray.length;
        if ((double)fArray[0] < -1.0E-4 || (double)fArray[0] > 1.0E-4) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("FloatValueInterpolator0"));
        }
        if ((double)(fArray[this.knotsLength - 1] - 1.0f) < -1.0E-4 || (double)(fArray[this.knotsLength - 1] - 1.0f) > 1.0E-4) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("FloatValueInterpolator1"));
        }
        this.knots = new float[this.knotsLength];
        for (n2 = 0; n2 < this.knotsLength; ++n2) {
            if (n2 > 0 && fArray[n2] < fArray[n2 - 1]) {
                throw new IllegalArgumentException(J3dUtilsI18N.getString("FloatValueInterpolator2"));
            }
            this.knots[n2] = fArray[n2];
        }
        if (this.knotsLength != fArray2.length) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("FloatValueInterpolator3"));
        }
        this.values = new float[this.knotsLength];
        for (n2 = 0; n2 < this.knotsLength; ++n2) {
            this.values[n2] = fArray2[n2];
        }
    }

    void setValue(int n2, float f2) {
        this.values[n2] = f2;
    }

    float getValue(int n2) {
        return this.values[n2];
    }

    protected void computePathInterpolation() {
        float f2 = this.getAlpha().value();
        for (int i2 = 0; i2 < this.knotsLength; ++i2) {
            if (!(i2 == 0 && f2 <= this.knots[i2]) && (i2 <= 0 || !(f2 >= this.knots[i2 - 1]) || !(f2 <= this.knots[i2]))) continue;
            if (i2 == 0) {
                this.currentInterpolationRatio = 0.0f;
                this.currentKnotIndex = 0;
                this.currentValue = this.values[0];
                break;
            }
            this.currentInterpolationRatio = (f2 - this.knots[i2 - 1]) / (this.knots[i2] - this.knots[i2 - 1]);
            this.currentKnotIndex = i2 - 1;
            this.currentValue = this.values[i2 - 1] + this.currentInterpolationRatio * (this.values[i2] - this.values[i2 - 1]);
            break;
        }
    }
}

